﻿using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR.RiskManagement;

namespace QualityManagement.API.Controllers.Risk_Management
{
    /// <summary>
    /// Controller for RiskLog
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class RiskLogController(IMediator _mediator) : BaseController
    {

        /// <summary>
        /// get all Risk Log
        /// </summary>
        /// <param name="riskLogResource"></param>
        /// <returns></returns>
        [HttpGet]
        [ClaimCheck("MANAGE_RISK_LOGS")]
        public async Task<IActionResult> GetCapaRequests([FromQuery] RiskLogResource riskLogResource)
        {
            var getRiskLogListCommand = new GetRiskLogListCommand()
            {
                RiskLogResource = riskLogResource
            };
            var result = await _mediator.Send(getRiskLogListCommand);
            var paginationMetadata = new
            {
                totalCount = result.TotalCount,
                pageSize = result.PageSize,
                skip = result.Skip,
                totalPages = result.TotalPages
            };
            Response.Headers.Append("X-Pagination",
                Newtonsoft.Json.JsonConvert.SerializeObject(paginationMetadata));

            return Ok(result);
        }
    }
}
